﻿/**
 * Minimap labels. Basic HTML/CSS supported.
 * Надписи на миникарте. Поддерживают HTML.
 */
{
  "labels": {
      // {{vehicle-class}} macro substitutions.
      // Подстановки макроса {{vehicle-class}}.
      "vehicleclassmacro": ${ "minimapLabels.xc":"labels.vehicleclassmacro" },
      // Textfields for tanks on minimap.
      // Текстовые поля для танков на миникарте.
      "units": {
        // Textfields switch for revealed units.
        // Выключатель добавочных текстовых полей для видимых юнитов.
        "revealedEnabled": ${ "minimapLabels.xc":"labels.units.revealedEnabled" },
        // Textfields switch for lost enemy units. Show last seen position.
        // Выключатель текстовых полей для пропавших врагов.
        "lostEnemyEnabled": ${ "minimapLabels.xc":"labels.units.lostEnemyEnabled" },
        // Формат поля.
        "format": { "$ref": { "file": "minimapLabels.xc", "path": "labels.units.format" },
          // Союзник.
          "ally": "<textformat leading='-2'><span class='mm_a'>    <font color='#70CC70'><i>{{name%.7s~..}}</i></font>\n<img src='xvm://configs/demon2597/img/mmSquads/al{{squad-num}}.png' width='5' height='7' align='baseline' vspace='-10'>{{vehicle}}</span></textformat>",
          // Тимкиллер.
          "teamkiller": "<textformat leading='-2'><span class='mm_t'>    <i>{{name%.7s~..}}</i>\n<img src='xvm://configs/demon2597/img/mmSquads/tk{{squad-num}}.png' width='5' height='7' align='baseline' vspace='-10'>{{vehicle}}</span></textformat>",
          // Враг.
          "enemy": ${ "_rating.xc": "minimapLabelsAlt.formatEnemy" },
          // Мертвый союзник.
          "deadally": "<textformat leading='-3'><span class='mm_dot'>{{vehicle-class}}</span>\n<span class='mm_da'> {{vehicle}}</span></textformat>",
          // Мертвый тимкиллер.
          "deadteamkiller": "<textformat leading='-3'><span class='mm_dot'>{{vehicle-class}}</span>\n<span class='mm_dt'> {{vehicle}}</span></textformat>",
          // Мертвый противник.
          "deadenemy": "<textformat leading='-3'><span class='mm_dot'>{{vehicle-class}}</span>\n<span class='mm_de'> {{vehicle}}</span></textformat>",
          // Мертвый взводный.
          "deadsquad": "<textformat leading='-3'><span class='mm_dot'>{{vehicle-class}}</span><span class='mm_ds'> <i>{{name%.7s~..}}</i>\n {{vehicle}}</span></textformat>"
        },
        // CSS style (fonts and colors option)
        // CSS стиль (настройка шрифтов и цветов)
        "css": { "$ref": { "file": "minimapLabels.xc", "path": "labels.units.css" },
          "deadally": ".mm_da{font-family:$FieldFont; font-size:8px; color:#789963;} .mm_dot{font-family:XVMSymbol; font-size:15px; color:#006100;}",
          "deadteamkiller": ".mm_dt{font-family:$FieldFont; font-size:8px; color:#5B898C;} .mm_dot{font-family:XVMSymbol; font-size:15px; color:#06535C;}",
          "deadenemy": ".mm_de{font-family:$FieldFont; font-size:8px; color:#A6706C;} .mm_dot{font-family:XVMSymbol; font-size:15px; color:#750701;}",
          "deadsquad": ".mm_ds{font-family:$FieldFont; font-size:8px; color:#A68763;} .mm_dot{font-family:XVMSymbol; font-size:15px; color:#8F4F00;}"
        },
        // Fields shadow.
        // Тени полей.
        // "distance"- дистанция тени относительно поля, "angle"- угол тени при дистанции > 0, "alpha"- прозрачность, "blur"- размытие, "strength'- сила.
        "shadow": ${ "minimapLabels.xc":"labels.units.shadow" },
        // Field offset ralative to current icon (except lost - relative to enemy last seen position).
        // Смещение полей относительно текущей иконки (кроме lost и dead- относительно последних координат видимой позиции).
        "offset": { "$ref": { "file": "minimapLabels.xc", "path": "labels.units.offset" },
          "deadally":	    {"x": -6, "y": -11},
          "deadteamkiller": {"x": -6, "y": -11},
          "deadenemy":	    {"x": -6, "y": -11},
          "deadsquad":	    {"x": -6, "y": -11}
        },
        // Прозрачность текстовых полей.
        "alpha": ${ "minimapLabels.xc":"labels.units.alpha" }
      },
      // Textfield for map side size. 1000m, 700m, 600m.
      // Поле размера стороны карты. Например, 1000м, 700м, 600м.
      "mapSize": ${ "minimapLabels.xc":"labels.mapSize" }
    }
}